/****************************************************************************

	Bareknuckle Boxin' with Casey

	or "Beat the Computer Science Student"

	See the page at
<a href=

http://www.cec.wustl.edu/~casey/pages/box.html

>this location</a>

	All code, associated images, sound, and web site Copyright 1996 by Casey Connor
	All rights reserved.

	Distribute, modify, and use at will. Please maintain
	copyright information. Absolutely no guarantees whatsoever
	explicit or implied pertaining to the use or results of use
	of this software.

	Here we get back to the old school.
	Boxing the way god meant it to be.

	INSTRUCTIONS:
 
	It's rather simple, really. Also the way god meant it to be.

	Up and down arrow to switch where the invisible punching
	focus is (face or stomach), space to punch. S or s to begin the
	game as well. P or p to pause. S or s after a knockout to start again.
	S or s to skip the little movie at the beginning as well.

	i or I links to a page (listed above) that has essesntially this info on it, but with
	oh so much more (like updates, etc...)

	This is poor object-oriented programming at its very best. :-)

	casey@cec.wustl.edu
	http://www.cec.wustl.edu/~casey/

 ***************************************************************************/

// notes;
// Multithread/keydown problems (see HitCasey)
// globalize clippointers
// pauseing when screen is left...
// drawing one frame late on init image thing... weirdorama...
// FIGURE THAT OUT and fix the other hack around places...
// Don't always post talk
// why is it post sleep talking for no reason?
// Leaving only after inited!
// Pausing logic is messed...
// only talk sometimes...

import java.net.URL;
import java.net.MalformedURLException;
import java.lang.InterruptedException;
import java.lang.NumberFormatException;
import java.lang.SecurityException;
import java.applet.AudioClip;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.MediaTracker;
import java.awt.Image;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.Event;
import java.awt.Font;
import java.util.Date;

/****************************************************************************

	Box.class

	Here we have all the global variables. "Think globally, act locally,"
	that's what I always say. The Java people would be rolling in their
	graves were they dead.

 ***************************************************************************/

public class Box extends java.applet.Applet implements Runnable {

	String			copydatestring = "1996";
	String			versionstring = "1.0";
	Thread			runner;
	int			cDanceDelay = 750;
	double			cTrashChance = .39;
	int			numMedObjLeft;

	// Game state variables
	// I guess I should just swallow my pride and write a class
 	// for enumerated data types. Maybe. Can you tell by the number
	// of globals that I'm not the most CS-oriented programmer
	// sometimes?

	int					cGameState;
	static final int			INITING      = 0;
	static final int			SPLASHING    = 1;
	static final int			SPLASHED     = 2;
	static final int			PICKINGFIGHT = 3;
	static final int			FIGHTING     = 4;
	static final int			PAUSED       = 5;
	static final int			ERROR	     = 6;

	// Error types

	int					cError;
	String					cErrorString;
	static final int			BADMAINIMAGEURL = 0;
	String					cBADMAINIMAGEURL = "malformed main image data URL";
	static final int			BADMAINIMAGE = 1;
	String					cBADMAINIMAGE = "couldn't get main image data";
	static final int			BADSOUNDURL = 2;
	String					cBADSOUNDURL = "couldn't form a sound URL properly";
	static final int			BADINITIMAGEURL = 3;
	String					cBADINITIMAGEURL = "malformed init image URL";
	static final int			BADINITIMAGE = 4;
	String					cBADINITIMAGE = "couldn't get init image";

	// When fighting, Casey state variables

	int					cCaseyState;
	static final int			GETTINGREADY = 0;
	static final int			DANCING      = 1;
	static final int			NODDINGOFF   = 2;
	static final int			SLEEPING     = 3;
	static final int			VICTORY      = 4;
	static final int			DEFEAT       = 5;

	// Dancing state variables

	int					cDanceState;
	static final int			LEFT =  0;
	static final int			RIGHT = 1;

	// Punching results, state variables
	// This is not currently used anywhere, but
	// I change it just for good measure. Maybe it'll
	// be handy some day.

	int					cPunchResult;
	static final int			NOPUNCHES     = 0;
	static final int			JUSTFACEHIT   = 1;
	static final int			JUSTBODYHIT   = 2;
	static final int			JUSTFACEBLOCK = 3;
        static final int			JUSTBODYBLOCK = 4;
	static final int			JUSTPUNCHED   = 5;
	static final int			JUSTWOKEUP    = 6;

	// Casey's health, enemy's health, from 0 to 1

	double cCaseyHealth, cEnemyHealth;

	// Punching focus

	int			cFocus;
	int			LOFOCUS = 0;
	int			HIFOCUS = 1;

	// Current time variable, used in the timing algorithm
	// in Fight() to keep a reasonably steady dancing pace
	// regardless of the machine...

	Date			cCurrentTime;
	Date			cTargetTime;

	// Difficulty factor... Lower is harder. 0 min.

	double			cDifficultyFactor;
	double			CDIFFICULTYFACTORDEFAULT = .4;

	// *** IMAGES ***

	int			imagewidth = 300;
	int			imageheight = 300;
	int			numImages = 1;	// As in files to be loaded, not
						// including the init image...

	Image			iInitImage;
	Image			iInputImage;

	Image			iIniting;
	Image			iSplash;
	Image			iWaiting;
	Image			iAroused;
	Image			iArousedTalking1;
	Image			iArousedTalking2;
	Image			iGettingReady;
	Image			iDanceLeft;
	Image			iDanceRight;
	Image			iPunchLeft;
	Image			iPunchRight;
	Image			iHitHi;
	Image			iHitLo;
	Image			iBlockHi;
	Image			iBlockLo;
	Image			iNoddingOff;
	Image			iSleeping;
	Image			iFalling;
	Image			iDefeat;
	Image			iPaused;

//	Image			currImage;

	// *** Audio Clips ***

	// Echo name changes in LoadSounds() !!!
	// Also to StopLoopingClips and StopAllClips !!!
	// Also to below in lengths section !!!
	// Boy this is poor !!!

	int			sNumAudioClips = 43;
	AudioClip		sInitingWords;
	AudioClip		sInitingMusic;
	AudioClip		sSplashWords;
	AudioClip		sSplashMusic;
	AudioClip		sWaiting;
	AudioClip		sAroused;
	AudioClip		sChallenge;
	AudioClip		sAcceptance;
	AudioClip		sGettingReady;
	AudioClip		sBreathing1;
	AudioClip		sBreathing2;
	AudioClip		sBreathing3;
	AudioClip		sBreathing4;
	AudioClip		sTrash1;
	AudioClip		sTrash2;
	AudioClip		sTrash3;
	AudioClip		sTrash4;
	AudioClip		sTrash5;
	AudioClip		sTrash6;
	AudioClip		sTrash7;
	AudioClip		sTrash8;
	AudioClip		sPunch1;
	AudioClip		sPunch2;
	AudioClip		sHitHi;
	AudioClip		sHitLo;
	AudioClip		sBlockHi;
	AudioClip		sBlockLo;
	AudioClip		sPostHitTrashSleep1;
	AudioClip		sPostHitTrashSleep2;
	AudioClip		sPostHitTrash1;
	AudioClip		sPostHitTrash2;
	AudioClip		sPostHitTrash3;
	AudioClip		sPostHitTrash4;
	AudioClip		sPostPunchTrash1;
	AudioClip		sPostPunchTrash2;
	AudioClip		sPostPunchTrash3;
	AudioClip		sPostPunchTrash4;
	AudioClip		sNoddingOff;
	AudioClip		sSleeping;
	AudioClip		sVictory;
	AudioClip		sDefeat;
	AudioClip		sFalling;
	AudioClip		sLeaving;

	// *** Audio Clip Lengths ***

	long			sInitingWordsLength=2599;
	long			sInitingMusicLength=5388;
	long			sSplashWordsLength;
	long			sSplashMusicLength;
	long			sWaitingLength=4237;
	long			sArousedLength=2536;
	long			sChallengeLength=3053;
	long			sAcceptanceLength=4109;
	long			sGettingReadyLength=4620;
	long			sBreathing1Length=2797;
	long			sBreathing2Length=1985;
	long			sBreathing3Length=3025;
	long			sBreathing4Length=4371;
	long			sTrash1Length=763;
	long			sTrash2Length=1292;
	long			sTrash3Length=1239;
	long			sTrash4Length=4141;
	long			sTrash5Length=924;
	long			sTrash6Length=2672;
	long			sTrash7Length=1227;
	long			sTrash8Length=1422;
	long			sPunch1Length=297;
	long			sPunch2Length=331;
	long			sHitHiLength=344;
	long			sHitLoLength=310;
	long			sBlockHiLength=227;
	long			sBlockLoLength=348;
	long			sPostHitTrashSleep1Length=1473;
	long			sPostHitTrashSleep2Length=1752;
	long			sPostHitTrash1Length=393;
	long			sPostHitTrash2Length=2728;
	long			sPostHitTrash3Length=1616;
	long			sPostHitTrash4Length=1119;
	long			sPostPunchTrash1Length=872;
	long			sPostPunchTrash2Length=798;
	long			sPostPunchTrash3Length=1796;
	long			sPostPunchTrash4Length=926;
	long			sNoddingOffLength=3510;
	long			sSleepingLength=5932;
	long			sVictoryLength=3554;
	long			sDefeatLength=577;
	long			sFallingLength=2007;
	long			sLeavingLength=2258;

	String			linkURLstring = "http://www.cec.wustl.edu/~casey/pages/box.html";
	URL			linkURL;

	// I made this global so I didn't have to do a method call in every single
	// function.

	Graphics		g = this.getGraphics();

/****************************************************************************

*****	init()

	Doesn't do much. Just prepares the dates used in the unused
	scheduling routines. Well, maybe one of them is used. Who knows.

 ***************************************************************************/

	public void init()
	{
//System.out.println("initing");
		cGameState = INITING;
		cCurrentTime = new Date();
		cTargetTime  = new Date();
		numMedObjLeft = numImages + sNumAudioClips - 2; // -2 because 2 init sounds shouldn't be counted...

		g = this.getGraphics();
	}

/****************************************************************************

*****		start()

	Starts Casey breathing and gets the thread going.

 ***************************************************************************/

	public void start()
	{
//System.out.println("starting");
		if ((cGameState != PAUSED) && (cGameState != INITING))
		{
			cGameState = FIGHTING;
			SetBreathing(cCaseyHealth);
		}
		else
		if (cGameState != INITING)
			g.drawImage(iPaused, 0, 0, this);

		if (runner == null)
		{
			runner = new Thread(this);
			runner.start();
			runner.setPriority(Thread.MIN_PRIORITY);
		}
	}

/****************************************************************************

*****	stop()

	Stops all sounds. If you leave when Casey is nodding off, he wakes
	up. If you leave when he's not asleep, he makes a little comment
	about it. Then the game is paused. Nice, eh?

 ***************************************************************************/

	public void stop()
	{
		if (runner != null)
		{
			runner.stop();
			runner=null;
		}

		if (cGameState != INITING)
			StopAllClips();
		else
			if (sInitingMusic != null)
				sInitingMusic.stop();

		if (cGameState == FIGHTING)
		{
			if (cCaseyState != SLEEPING)
			{
				sLeaving.play();
				pause(sLeavingLength);
				if (cCaseyState == NODDINGOFF)
					cCaseyState = DANCING;
			}

			PauseGame();
		}
	}

/****************************************************************************

*****	update( Graphics gg )

	Overloads the default update method. paint() is not as yet
	overloaded.

 ***************************************************************************/

	public void update(Graphics gg)
	{
	}

/****************************************************************************

*****	run()

	The main thread. Calls other functions depending on the game state.
	You'll note some states missing; that's cause the thread shouldn't
	actually do anything while in those states. Getting out is handled
	by KeyDown events. See KeyDown(...)...

 ***************************************************************************/

	public void run()
	{
//System.out.println("running");

		while (true)
		{

		switch (cGameState)
		{
		case	INITING:
				GameInit();
			break;

		case	SPLASHING:
				GameSplashing();
			break;

		case	SPLASHED:
				runner.suspend();
			break;

		case	PICKINGFIGHT:
				GamePickingFight();
			break;

		case	FIGHTING:
				Fight();
			break;

		case	PAUSED:
			break;

		case	ERROR:
			System.out.println("Box " + versionstring +": Error in program. Unable to continue.");
			System.out.println("Unhelpful reason: " + cErrorString);
			showStatus("Box " + versionstring +": Uncontinuable Error: " + cErrorString);
			runner.stop();
			break;

		} // End of switch
		} // End of while
	} // End of run

/****************************************************************************

*****	GameInit()

	The Initializing function. Does the "please wait" stuff.
	Loads the sounds. Gets the parameters. Gets the image and divides
	it up into the sub images. Pre-displays the images on
	off-screen graphics so that they'll display properly later on. Sets
	the game state to SPLASHING and Casey's fighting dance state to LEFT.
	(This is here becase it needs to be initialized...)

 ***************************************************************************/

	// Why does this need to be here to be sure to be initialized?
	// Weirdorama... I used to have it within GameInit, but no dice...
	URL mainimageURL;
	URL initImageURL;

	public void GameInit()
	{
//		Graphics g = this.getGraphics();

		g = this.getGraphics();
		String mydiff;

//System.out.println("GameInit");
		String mediabase;
		MediaTracker myTracker = new MediaTracker(this);

		ShowDrawnInitScreen();

		mediabase = getParameter("mediabase");

		// I don't know if this accomplishes anything:
		if (mediabase == null)
			mediabase = getDocumentBase().toString();

		try
		{
			initImageURL = new URL(mediabase + "initimage.jpg");
		}
		catch (MalformedURLException e) { cGameState = ERROR;
                                                  cError = BADINITIMAGEURL;
						  cErrorString = cBADINITIMAGEURL; }

		if (initImageURL != null)
		{
			iInitImage = getImage(initImageURL);
			myTracker.addImage(iInitImage, 1);
		}

		if (myTracker.isErrorID(1))
		{
			cGameState = ERROR;
			cError = BADINITIMAGE;
			cErrorString = cBADINITIMAGE;
		}

		// Display the init image (hopefully) and start the countdown of
		// media objects:

		PrepInitImage();	// This may be excessive...

		Countdown();

		GetAndPlayInitSounds(mediabase);

		cDifficultyFactor = CDIFFICULTYFACTORDEFAULT;
		mydiff = getParameter("difficulty");
		if (mydiff != null)
			if (mydiff.length()!=0)
				try { cDifficultyFactor = Math.abs((double)Long.parseLong(mydiff) / (double)100.0); }
				catch (NumberFormatException e)
					{ cDifficultyFactor = CDIFFICULTYFACTORDEFAULT; }

		LoadSounds(mediabase);

// Pause here for network stuff?

		try
		{
			mainimageURL = new URL(mediabase + "boximage.jpg");
		}
		catch (MalformedURLException e) { cGameState = ERROR;
                                                  cError = BADMAINIMAGEURL;
						  cErrorString = cBADMAINIMAGEURL; }

		if (mainimageURL != null)
		{
			iInputImage = getImage(mainimageURL);
			myTracker.addImage(iInputImage, 0);
		}

		if (myTracker.isErrorID(0))
		{
			cGameState = ERROR;
			cError = BADMAINIMAGE;
			cErrorString = cBADMAINIMAGE;
		}

		try
		{ linkURL = new URL(linkURLstring); }
		catch (MalformedURLException e) { }

		try { myTracker.waitForID(0); }
		catch(InterruptedException e) {}

		Countdown();

//System.out.println("Cutting...");
		CutUpImage();
//System.out.println("Cut...");

//while (this.imageUpdate(iIniting, ALLBITS, 0, 0, imagewidth, imageheight)) {

		showStatus("Box "+versionstring+": Pre-drawing images... Hang on...");
		PrepImages();

//		g.drawImage(iIniting, 0, 0, this);
//repaint();
//repaint();
//		currImage = iIniting;
//		repaint();

//		init all variables watching for state==ERROR...
//		get applet's width and height?

		cDanceState = LEFT;
		if (cGameState != ERROR)
			cGameState=SPLASHING;
	}

/****************************************************************************

*****	GameSplashing

	Draws the "splash screen" on the screen. Plays the appropriate
	sounds.

 ***************************************************************************/

	public void GameSplashing()
	{
//		Graphics g = this.getGraphics();

		showStatus("Box "+versionstring+" Ready.");
//System.out.println("splashing");

while (this.imageUpdate(iSplash, ALLBITS, 0, 0, imagewidth, imageheight)) { }
		StopLoopingClips();
		g.drawImage(iSplash, 0, 0, this);
		repaint();

//repaint();
//		currImage = iSplash;
//		repaint();

		sSplashMusic.loop();
		pause(500);
		sSplashWords.play();

		cGameState = SPLASHED;
	}

/****************************************************************************

*****	GamePickingFight

	Plays the little intro movie. You can skip this by hitting "s" or "S".

 ***************************************************************************/

	public void GamePickingFight()
	{
//		Graphics g = this.getGraphics();
//System.out.println("picking fight");

		int i;
		Date endTime = new Date();
//System.out.println("waiting for fight");
		g.drawImage(iWaiting, 0, 0, this);
		StopLoopingClips();
//		currImage = iWaiting;
//		repaint();
		sWaiting.loop();
		pause((int)((double)sWaitingLength*(double)1.5));
		sWaiting.stop();

		g.drawImage(iAroused, 0, 0, this);
//System.out.println("Now Aroused");
//		currImage = iAroused;
//		repaint();

		pause(2000);

		endTime.setTime((long)(System.currentTimeMillis() + sArousedLength));

//System.out.println("starting to ask why here");

		sAroused.play();

		for (i=0; (endTime.getTime() > 
                                        System.currentTimeMillis()); i++)
		{
			if (Math.floor(i/2) == (double)i/2)
			{
				g.drawImage(iArousedTalking1, 0, 0, this);
//				currImage = iArousedTalking1;
//				repaint();
			}
			else
			{
				g.drawImage(iArousedTalking2, 0, 0, this);
//				currImage = iArousedTalking2;
//				repaint();
			}

			pause(180);
		}

		g.drawImage(iAroused, 0, 0, this);
//System.out.println("done talking, now aroused again");
//		currImage = iAroused;
//		repaint();

		pause(1800);
		sChallenge.play();
		pause(sChallengeLength + 2600);

		sAcceptance.play();

		endTime.setTime((long)(System.currentTimeMillis() + sAcceptanceLength));

//System.out.println("starting to respond");
		for (i=0; (endTime.getTime() > 
                                        System.currentTimeMillis()); i++)
		{
			if (Math.floor(i/2) == (double)i/2)
			{
				g.drawImage(iArousedTalking1, 0, 0, this);
//				currImage = iArousedTalking1;
//				repaint();
			}
			else
			{
				g.drawImage(iArousedTalking2, 0, 0, this);
//				currImage = iArousedTalking2;
//				repaint();
			}

			pause(180);
		}

		g.drawImage(iAroused, 0, 0, this);
		pause(1900);
		g.drawImage(iWaiting, 0, 0, this);
		pause(1500);

//		currImage = iAroused;
//		repaint();

//		init fighting vars
//System.out.println("going into fighting mode");

		InitFightingVars();
	}

/****************************************************************************

*****	Fight()

	This procedure is called by run() when the game is in fighting mode.
	It includes the little timing routine for dancing, trash-talking,
	falling asleep, getting ready before the fight, and the null routines
	for what to do when somene gets KO'd...

 ***************************************************************************/

	public void Fight()
	{
//		Graphics g = this.getGraphics();
		double cEventVar;

		cCurrentTime.setTime(System.currentTimeMillis());

		if ((cTargetTime.getTime() <= cCurrentTime.getTime()) || cCaseyState == GETTINGREADY)
		{
			// I sure hope this is right.

//System.out.println("difference is "+(cCurrentTime.getTime() - cTargetTime.getTime()));
//System.out.println("cdan*ceil(abs(that)/dan) is "+(cDanceDelay*Math.ceil(Math.abs((double)(cCurrentTime.getTime()-cTargetTime.getTime()))/(double)cDanceDelay)));

// Well, I think this works. It attempts to set up a regular scheduled event that gets executed whenever it's due. And when it gets done,
// the next event will always fall into that event "grid". So if we were doing events every 10 ms, we did the first one at 0,
// and the next time we checked we were at 12 ms, we'd do the action and then schedule the next one for 20 (not 10+12=22) to attempt
// to keep a regular dancing rhythm. If we did the first at 0, and checked again at 43, the next would be scheduled at 50, etc...
// This probably isn't necessary. A simple target=now+delay would be fine for this game, but I thought I'd try this out. A timing
// routine, in general, is to "ensure" that the speed will be the same on various machines.

			cTargetTime.setTime((long)(cTargetTime.getTime() + 
				cDanceDelay*Math.ceil(Math.abs((double)(cCurrentTime.getTime() - 
				cTargetTime.getTime()))/(double)cDanceDelay)));

			cTargetTime.setTime(System.currentTimeMillis() + cDanceDelay);

//System.out.println("*** targettime "+cTargetTime.getTime()+" *** current is "+cCurrentTime.getTime());
//if (cCaseyState != GETTINGREADY) pause(cDanceDelay);
			switch (cCaseyState)
			{

			case DANCING:

				cEventVar = Math.random();

				if (cEventVar < .855)
				{
					Dance();
				}
				else
				if ((cEventVar >= .855) && (cEventVar < .87))
				{
					TrashTalk();
//cCaseyState = NODDINGOFF;
				}
				else
				if ((cEventVar >= .87) && (cEventVar < .996))
				{
					Punch();
				}
				if (cEventVar >= .996)
					cCaseyState = NODDINGOFF;
			break;

			case NODDINGOFF:
//System.out.println("Nodding off");
				g.drawImage(iNoddingOff, 0, 0, this);
				StopLoopingClips();
				sNoddingOff.play();
				pause(sNoddingOffLength);
				g.drawImage(iSleeping, 0, 0, this);
				sSleeping.loop();
				cCaseyState = SLEEPING;
//System.out.println("going to sleep");
			break;

			case GETTINGREADY:
//System.out.println("getting ready");
				g.drawImage(iGettingReady, 0, 0, this);
				StopLoopingClips();
				sGettingReady.play();
				pause(sGettingReadyLength);
				pause(1700);
				SetBreathing(cCaseyHealth);
				cCaseyState = DANCING;
				Dance();
//System.out.println("starting to dance");
			break;

			case SLEEPING:
			break;

			case VICTORY:
			break;

			case DEFEAT:
			break;

			} // End of switch
		} // End of if (checking to see if it's time yet)
	} // End of fight

/****************************************************************************

*****	Dance()

	Simply toggles the current image of Casey dancing.

 ***************************************************************************/

	public void Dance()
	{
//		Graphics g = this.getGraphics();

		if (cDanceState == LEFT)
		{
//System.out.println("Dance left");
			g.drawImage(iDanceLeft, 0, 0, this);
//			currImage = iDanceLeft;
//			repaint();
			cDanceState = RIGHT;
		}
		else
		{
//System.out.println("Dance right");
			g.drawImage(iDanceRight, 0, 0, this);
//			currImage = iDanceRight;
//			repaint();
			cDanceState = LEFT;
		}
	}

/****************************************************************************

*****	Punch()

	Executes a punch on the part of Casey, deals with resulting KO's as
	necessary. No, the defender can not block when Casey punches. I felt
	that it was only appropriate.	

 ***************************************************************************/

	public void Punch()
	{
//System.out.println("punch");
//		Graphics g = this.getGraphics();

		if (Math.random() >= .5)
		{
			g.drawImage(iPunchLeft, 0, 0, this);
//			currImage = iPunchLeft;
//			repaint();
		}
		else
		{
			g.drawImage(iPunchRight, 0, 0, this);
//			currImage = iPunchRight;
//			repaint();
		}

		StopLoopingClips();

		if (Math.random() >= .5)
		{
			sPunch1.play();
			pause(sPunch1Length);
		}
		else
		{
			sPunch2.play();
			pause(sPunch2Length);
		}

		cEnemyHealth -= .07 + Math.random()*.13;

//System.out.println("Enemy health is "+cEnemyHealth);

		if (cEnemyHealth > 0)
		{
			cPunchResult = JUSTPUNCHED;
			Dance();
			if (trashchance())
				PostPunchTrash();
			SetBreathing(cCaseyHealth);
		}
		else
		{
			cCaseyState = VICTORY;
			EnemyKO();
		}
	}

/****************************************************************************

*****	keyDown( Event evt, int key )

	Handles keyboard input. Pretty self-explanatory, I think.

 ***************************************************************************/

	public boolean keyDown(Event evt, int key)
	{
		switch (key)
		{
		case Event.UP:
			cFocus = HIFOCUS;
		break;

		case Event.DOWN:
			cFocus = LOFOCUS;
		break;

		case ' ':
			if ((cGameState == FIGHTING) && (cCaseyState != GETTINGREADY)
			    && (cCaseyState != VICTORY) && (cCaseyState !=DEFEAT))
				HitCasey();
//			else
//			if ((cGameState == FIGHTING) && (cCaseyState == GETTINGREADY))
//				cCaseyState = DANCING;
//			else
//			if (cGameState = PICKINGFIGHT)
//				cGameState = FIGHTING;
// Have to init fighting vars and stuff for these?
		break;

		case 'p':
		case 'P':
			if ((cGameState == FIGHTING) && (cCaseyState != VICTORY)
			    && (cCaseyState != DEFEAT))
				{
				cGameState = PAUSED;
				PauseGame();
				}
			else
			if (cGameState == PAUSED)
			{
				cGameState = FIGHTING;
				if (cCaseyState == SLEEPING)
				{
					g.drawImage(iSleeping, 0, 0, this);
					sSleeping.loop();
				}
				else
				{
					if (cCaseyState == NODDINGOFF)
						g.drawImage(iNoddingOff, 0, 0, this);
					else
					{
						Dance();
						SetBreathing(cCaseyHealth);
					}
				}

				runner.resume();
			}
		break;

		case 'i':
		case 'I':
			StopLoopingClips();
			
			getAppletContext().showDocument(linkURL);
		break;

		case 's':
		case 'S':
			if (cGameState == SPLASHED)
				cGameState = PICKINGFIGHT;
			else
			if ((cGameState == FIGHTING) && ((cCaseyState == DEFEAT)
							 || (cCaseyState == VICTORY)))
				cGameState = SPLASHING;
			else
			if (cGameState == PICKINGFIGHT)
			{
				StopAllClips();
				InitFightingVars();

				// The following should break out of what was running...
				// In other words the previous thread was running the
				// picking fight thing (likely) and now will go on to fight...
				// All variables should be safe if PICKINGFIGHT was the state...

				if (runner != null)
					runner.stop();
				runner = new Thread(this);
				runner.start();
				runner.setPriority(Thread.MIN_PRIORITY);
			}

			runner.resume();
		break;

		} // End of switch

	return(true);
	} // End of keyDown

/****************************************************************************

*****	HitCasey()

	Executes a strike at Casey. Deals with resulting KO's.

 ***************************************************************************/

// Uh oh, issues of multithreadedness? Does a new thread get created to service
// keydown events? if so they call this and we've got two using the same vars
// as in fight which causes overlapping results... Yikes...

	public void HitCasey()
	{
//		Graphics g = this.getGraphics();

		double luck;
		boolean success;

		luck = Math.random();
		success = false;

		// Determining whether or not the hit is successful:

		if (((cCaseyHealth / cEnemyHealth)*luck) < cDifficultyFactor)
			success = true;

		StopLoopingClips();

		if (success)
		{
			if (cFocus == HIFOCUS)
			{
				g.drawImage(iHitHi, 0, 0, this);
				sHitHi.play();
				pause(sHitHiLength);
				cCaseyHealth -= .05 + .15*cEnemyHealth*Math.random();
				cPunchResult = JUSTFACEHIT;
//System.out.println("Just hit casey hi");
			}
			else
			{
				g.drawImage(iHitLo, 0, 0, this);
				sHitLo.play();
				pause(sHitLoLength);
//System.out.println("Just hit casey lo");
				cCaseyHealth -= .05 + .15*cEnemyHealth*Math.random();
				cPunchResult = JUSTBODYHIT;
			}

			if (cCaseyHealth > 0)
			{
				Dance();

				if ((cCaseyState == SLEEPING)
					|| (cCaseyState == NODDINGOFF))
				{
					cCaseyState = DANCING;
					PostHitTrashSleep();
				}
				else
				{
					if (trashchance())
						PostHitTrash();
				}

				SetBreathing(cCaseyHealth);			
			} // End if caseyhealth > 0
			else
			{
				cCaseyState = DEFEAT;
				CaseyKO();
			} // End if caseyhealth < 0
		} // End if success
		else
		{ // Begin if !success
			if (cFocus == HIFOCUS)
			{
				g.drawImage(iBlockHi, 0, 0, this);
				sBlockHi.play();
				pause(sBlockHiLength);
//System.out.println("Just failed to hit casey hi");
				cCaseyHealth -= .04 + .1*cCaseyHealth*Math.random();
				cPunchResult = JUSTFACEBLOCK;
			}
			else
			{
				g.drawImage(iBlockLo, 0, 0, this);
				sBlockLo.play();
				pause(sBlockLoLength);
//System.out.println("Just failed to hit casey lo");
				cCaseyHealth -= .03 + .1*cCaseyHealth*Math.random();
				cPunchResult = JUSTBODYBLOCK;
			} // End if focus == or != HI

			if (cEnemyHealth > 0)
			{
				Dance();

				if ((cCaseyState == SLEEPING) || (cCaseyState == NODDINGOFF))
				{
					cCaseyState = DANCING;
					PostBlockTrashSleep();
				}
				else
					if (trashchance())
						PostBlockTrash();

				SetBreathing(cCaseyHealth);
			}
			else
			{
				cCaseyState = VICTORY;
				EnemyKO();
			} // End if enemyhealth < or > 0...
		} // End if !success
	} // End of HitCasey

/****************************************************************************

*****	CaseyKO()

	Do the movie-like stuff involved when Casey gets KO'd.

 ***************************************************************************/

	public void CaseyKO()
	{
//		Graphics g = this.getGraphics();

runner.suspend();
		StopLoopingClips();

		g.drawImage(iFalling, 0, 0, this);
		sFalling.play();
		pause(sFallingLength);
//System.out.println("casey is down");
		g.drawImage(iDefeat, 0, 0, this);
		sDefeat.play();
		pause(sDefeatLength);
	}

/****************************************************************************

*****	EnemyKO()

	Do the movie-like stuff involved when the Enemy (that's you) gets KO'd.

 ***************************************************************************/

	public void EnemyKO()
	{
//		Graphics g = this.getGraphics();

Image os;
Graphics osg;
os = createImage(imagewidth, imageheight);
osg = os.getGraphics();

		g.setColor(Color.black);
		g.fillRect(0, 0, imagewidth, imageheight);
		g.setColor(new Color(160,20,18));
		g.setFont(new Font("Helvitica", Font.BOLD, 210));
		g.drawString("KO", -8, 200);
		g.setFont(new Font("Helvetica", Font.PLAIN, 25));
		g.drawString("Now You Feel The Pain", 20, 270);

// Ugly, ugly, ugly, but this is the only way I can get the other stuff to refresh
// on the normal screen...

osg.drawImage(iIniting, 0, 0, this);

//System.out.println("EnemyKO'd...");
		StopLoopingClips();
		sVictory.play();
		pause(sVictoryLength);
runner.suspend();
	}

/****************************************************************************

*****	SetBreathing( double cHealth )

	Set the breathing sound in the background based on the health value
	received. (Health goes from 0 to 1.)

 ***************************************************************************/

	public void SetBreathing(double cHealth)
	{
		     if (cHealth < .25)
			sBreathing4.loop();
		else if ((cHealth >= .25) && (cHealth < .5))
			sBreathing3.loop();
		else if ((cHealth >= .5) && (cHealth < .75))
			sBreathing2.loop();
		else if (cHealth >= .75)	
			sBreathing1.loop();
	} // End of SetBreathing

/****************************************************************************

*****	TrashTalk()

	Say one of eight random things to insult the opponent.

 ***************************************************************************/

	public void TrashTalk()
	{
		double myeventvar = Math.random();
		int choice;

//System.out.println("Trashtaklin");

		choice = (int)Math.floor(myeventvar*7.99999999999999) + 1;

		StopLoopingClips();

		switch (choice)
		{
			case 1:
				sTrash1.play();
				pause(sTrash1Length);
			break;

			case 2:
				sTrash2.play();
				pause(sTrash2Length);
			break;
			case 3:
				sTrash3.play();
				pause(sTrash3Length);
			break;
			case 4:
				sTrash4.play();
				pause(sTrash4Length);
			break;
			case 5:
				sTrash5.play();
				pause(sTrash5Length);
			break;
			case 6:
				sTrash6.play();
				pause(sTrash6Length);
			break;
			case 7:
				sTrash7.play();
				pause(sTrash7Length);
			break;
			case 8:
				sTrash8.play();
				pause(sTrash8Length);
			break;
		}

// Because of annoying netscape bug
pause(130);

		SetBreathing(cCaseyHealth);
	}

/****************************************************************************

*****	PostHitTrash()

	Casey says one of four random things to save face after being hit.

 ***************************************************************************/

	public void PostHitTrash()
	{
		double myeventvar = Math.random();
		int choice;

//System.out.println("Post Hit Trashtaklin");

		choice = (int)Math.floor(myeventvar*3.9999999999) + 1;

		StopLoopingClips();

		switch (choice)
		{
			case 1:
				sPostHitTrash1.play();
				pause(sPostHitTrash1Length);
			break;

			case 2:
				sPostHitTrash2.play();
				pause(sPostHitTrash2Length);
			break;
			case 3:
				sPostHitTrash3.play();
				pause(sPostHitTrash3Length);
			break;
			case 4:
				sPostHitTrash4.play();
				pause(sPostHitTrash4Length);
			break;
		}

// Because of annoying netcsape bug
pause(130);
  
		SetBreathing(cCaseyHealth);
	}

/****************************************************************************

*****	PostPunchTrash()

	Say one of four things to make the opponent feel bad after being
	pummeled (as if the sting of shame from being struck by a computer
	scientist like a sack of potatos wasn't enough...)

 ***************************************************************************/

	public void PostPunchTrash()
	{
		double myeventvar = Math.random();
		int choice;

//System.out.println("Post Punch Trashtaklin");

		choice = (int)Math.floor(myeventvar*3.9999999999) + 1;

		StopLoopingClips();

		switch (choice)
		{
			case 1:
				sPostPunchTrash1.play();
				pause(sPostPunchTrash1Length);
			break;

			case 2:
				sPostPunchTrash2.play();
				pause(sPostPunchTrash2Length);
			break;
			case 3:
				sPostPunchTrash3.play();
				pause(sPostPunchTrash3Length);
			break;
			case 4:
				sPostPunchTrash4.play();
				pause(sPostPunchTrash4Length);
			break;
		}

// Because of annoying netscape bug
pause(130);

		SetBreathing(cCaseyHealth);
	}

/****************************************************************************

*****	PostBlockTrash()

	Say some trash after blocking. Right now just says normal trash.

 ***************************************************************************/

	public void PostBlockTrash()
	{
		PostHitTrash();
	}

/****************************************************************************

*****	PostBlockTrashSleep()

	Say some trash after blocking even though you were "asleep". Right
	now just says the normal post-sleep stuff.

 ***************************************************************************/

	public void PostBlockTrashSleep()
	{
		PostHitTrashSleep();
	}

/****************************************************************************

*****	PostHitTrashSleep()

	Say some trash when you're hit after sleeping.

 ***************************************************************************/

	public void PostHitTrashSleep()
	{
		double myeventvar = Math.random();
		int choice;

//System.out.println("Post Hit Sleep Trashtaklin");

		choice = (int)Math.floor(myeventvar*1.99999999) + 1;

		StopLoopingClips();

		switch (choice)
		{
			case 1:
				sPostHitTrashSleep1.play();
				pause(sPostHitTrashSleep1Length);
			break;

			case 2:
				sPostHitTrashSleep2.play();
				pause(sPostHitTrashSleep2Length);
			break;
		}

// Because of annoying netscape bug
pause(130);

		SetBreathing(cCaseyHealth);
	}

/****************************************************************************

*****	StopLoopingClips()

	Stop all potentially looping audio clips. (Because sometimes you want
	the sound to stop but you want the program to finish what it was
	saying. Some better AudioClip interface would be very nice, don't you
	think?)

 ***************************************************************************/

	public void StopLoopingClips()
	{
		sBreathing1.stop();
		sBreathing2.stop();
		sBreathing3.stop();
		sBreathing4.stop();
		sInitingMusic.stop();
		sSplashMusic.stop();
		sSleeping.stop();
	}

/****************************************************************************

*****	StopAllClips()

	Stop each and every audio clip (that this applet knows about.)

 ***************************************************************************/

	public void StopAllClips()
	{

		// Echo any changes to top !!!

		sInitingWords.stop();
		sInitingMusic.stop();
		sSplashWords.stop();
		sSplashMusic.stop();
		sWaiting.stop();
		sAroused.stop();
		sChallenge.stop();
		sAcceptance.stop();
		sGettingReady.stop();
		sBreathing1.stop();
		sBreathing2.stop();
		sBreathing3.stop();
		sBreathing4.stop();
		sTrash1.stop();
		sTrash2.stop();
		sTrash3.stop();
		sTrash4.stop();
		sTrash5.stop();
		sTrash6.stop();
		sTrash7.stop();
		sTrash8.stop();
		sPunch1.stop();
		sPunch2.stop();
		sHitHi.stop();
		sHitLo.stop();
		sBlockHi.stop();
		sBlockLo.stop();
		sPostHitTrashSleep1.stop();
		sPostHitTrashSleep2.stop();
		sPostHitTrash1.stop();
		sPostHitTrash2.stop();
		sPostHitTrash3.stop();
		sPostHitTrash4.stop();
		sPostPunchTrash1.stop();
		sPostPunchTrash2.stop();
		sPostPunchTrash3.stop();
		sPostPunchTrash4.stop();
		sNoddingOff.stop();
		sSleeping.stop();
		sVictory.stop();
		sDefeat.stop();
		sFalling.stop();
		sLeaving.stop();
	}

/****************************************************************************

*****	ShowDrawnInitScreen()

	Draws the text version of the init screen before the init image loads...

 ***************************************************************************/

	public void ShowDrawnInitScreen()
	{
		g.setColor(Color.black);
		g.fillRect(0, 0, imagewidth, imageheight);
		g.setFont(new Font("Times New Roman", Font.PLAIN, 30));
		g.setColor(new Color(160,20,18));
		g.drawString("Hang On...", 80, 160);
		showStatus("Box "+versionstring+": Hang On...");
	}

/****************************************************************************

*****	Countdown()

	Displays the initing image to offscreen graphics, draws the number
	of media objects left to load, decrements the value left.

 ***************************************************************************/

	public void Countdown()
	{
		Image offscreenImage;
		Graphics offscreengraphics;
		int x=100, y=189;

		offscreenImage = createImage(imagewidth, imageheight);
		offscreengraphics = offscreenImage.getGraphics();

		offscreengraphics.drawImage(iInitImage, 0, 0, this);
		offscreengraphics.setFont(new Font("Times New Roman", Font.BOLD, 80));
		offscreengraphics.setColor(Color.black);
// These are -1 because they don't seem to redraw until the last one comes up... I probably
// just don't understand the graphics interface well enough...
		offscreengraphics.drawString(""+Math.max(0,(numMedObjLeft-1)), (numMedObjLeft>10)?x+2:x+24+2, y+2);
		offscreengraphics.setColor(new Color(140,18,16));
		offscreengraphics.drawString(""+Math.max(0,(numMedObjLeft-1)), (numMedObjLeft>10)?x:x+24, y);
//		repaint();

		if (numMedObjLeft > 1)
			showStatus("Box "+versionstring+": Objects left to load: "+numMedObjLeft);
		else
			showStatus("Box "+versionstring+": Loading big image now...");

		g.drawImage(offscreenImage, 0, 0, this);

		numMedObjLeft--;
	}

/****************************************************************************

*****	CutUpImage()

	Call GetOneImage a lot to get all the individual images from the one
	big image that has all the frames in it.

 ***************************************************************************/

	public void CutUpImage()
	{
		iIniting = GetOneImage(1);
		iSplash = GetOneImage(2);
		iWaiting = GetOneImage(3);
		iAroused = GetOneImage(4);
		iArousedTalking1 = GetOneImage(5);
		iArousedTalking2 = GetOneImage(6);
		iGettingReady = GetOneImage(7);
		iDanceLeft = GetOneImage(8);
		iDanceRight = GetOneImage(9);
		iPunchLeft = GetOneImage(10);
		iPunchRight = GetOneImage(11);
		iHitHi = GetOneImage(12);
		iHitLo = GetOneImage(13);
		iBlockHi = GetOneImage(14);
		iBlockLo = GetOneImage(15);
		iNoddingOff = GetOneImage(16);
		iSleeping = GetOneImage(17);
		iFalling = GetOneImage(18);
		iDefeat = GetOneImage(19);
		iPaused = GetOneImage(20);
	}

/****************************************************************************

*****	GetOneImage( int num )

	Gets one image from the big image depending on the index number...

 ***************************************************************************/

	// Thanks to Frogger.java for the lead on how to do this.
	// Frogger - (C) 1996 Sam Taylor

	public Image GetOneImage(int num)
	{
		return(createImage(new FilteredImageSource(
			iInputImage.getSource(),
			new CropImageFilter((num-1)*imagewidth, 0, imagewidth, imageheight))));
	}


/****************************************************************************

*****	LoadSounds( String mediabase )

	Loads all the sounds from the mediabase directory.

 ***************************************************************************/

// Echo name changes at top!!!

	// Again, there has to be a better way than declaring this here and not inside...
	URL audioURL;

// O, programming gods, forgive me for this vile sin I am about to commit:

	public void LoadSounds(String mediabase)
	{
//		MediaTracker soundTracker = new MediaTracker(this);

		// The first two items in both arrays are ignored, see comments
		// about GetAndPlayInitSounds() just below.

		String[] names = { "sInitingWords","sInitingMusic",
"sSplashWords","sSplashMusic","sWaiting","sAroused","sChallenge",
"sAcceptance","sGettingReady","sBreathing1","sBreathing2","sBreathing3",
"sBreathing4","sTrash1","sTrash2","sTrash3","sTrash4","sTrash5","sTrash6",
"sTrash7","sTrash8","sPunch1","sPunch2","sHitHi","sHitLo","sBlockHi",
"sBlockLo","sPostHitTrashSleep1","sPostHitTrashSleep2","sPostHitTrash1",
"sPostHitTrash2","sPostHitTrash3","sPostHitTrash4","sPostPunchTrash1",
"sPostPunchTrash2","sPostPunchTrash3","sPostPunchTrash4","sNoddingOff",
"sSleeping","sVictory","sDefeat","sFalling","sLeaving" };

		AudioClip[] clippointers = { sInitingWords,sInitingMusic,
sSplashWords,sSplashMusic,sWaiting,sAroused,sChallenge,sAcceptance,
sGettingReady,sBreathing1,sBreathing2,sBreathing3,sBreathing4,sTrash1,sTrash2,
sTrash3,sTrash4,sTrash5,sTrash6,sTrash7,sTrash8,sPunch1,sPunch2,sHitHi,sHitLo,
sBlockHi,sBlockLo,sPostHitTrashSleep1,sPostHitTrashSleep2,sPostHitTrash1,
sPostHitTrash2,sPostHitTrash3,sPostHitTrash4,sPostPunchTrash1,
sPostPunchTrash2,sPostPunchTrash3,sPostPunchTrash4,sNoddingOff,sSleeping,
sVictory,sDefeat,sFalling,sLeaving };

// Hmmm... clippointers is global, then sInitingWords = clippointers[0] and so on, then we can use it
// in stopallclips and stoploopingclips???

		for (int i=2; i<sNumAudioClips; i++)  // Start at 2 becase init sounds are now done in GetAndPlayInitSounds()
		{
			Countdown();

			try
			{
				audioURL = new URL(mediabase + names[i] + ".au");
			}
			catch (MalformedURLException e) { cGameState = ERROR;
                	                                  cError = BADSOUNDURL;
							  cErrorString = cBADSOUNDURL; }

			if (audioURL != null)
			{
				clippointers[i] = getAudioClip(audioURL);
			}

// Some day this will be implemented... :-)
//
//			if (clippointers[i] != null)
//				soundTracker.addClip(clippointers[i],i);

		}

//		soundTracker.waitForAll();

//		sInitingWords = clippointers[0];
//		sInitingMusic = clippointers[1]; // These are now done in GetAndPlayInitSounds()
		sSplashWords = clippointers[2];
		sSplashMusic = clippointers[3];
		sWaiting = clippointers[4];
		sAroused = clippointers[5];
		sChallenge = clippointers[6];
		sAcceptance = clippointers[7];
		sGettingReady = clippointers[8];
		sBreathing1 = clippointers[9];
		sBreathing2 = clippointers[10];
		sBreathing3 = clippointers[11];
		sBreathing4 = clippointers[12];
		sTrash1 = clippointers[13];
		sTrash2 = clippointers[14];
		sTrash3 = clippointers[15];
		sTrash4 = clippointers[16];
		sTrash5 = clippointers[17];
		sTrash6 = clippointers[18];
		sTrash7 = clippointers[19];
		sTrash8 = clippointers[20];
		sPunch1 = clippointers[21];
		sPunch2 = clippointers[22];
		sHitHi = clippointers[23];
		sHitLo = clippointers[24];
		sBlockHi = clippointers[25];
		sBlockLo = clippointers[26];
		sPostHitTrashSleep1 = clippointers[27];
		sPostHitTrashSleep2 = clippointers[28];
		sPostHitTrash1 = clippointers[29];
		sPostHitTrash2 = clippointers[30];
		sPostHitTrash3 = clippointers[31];
		sPostHitTrash4 = clippointers[32];
		sPostPunchTrash1 = clippointers[33];
		sPostPunchTrash2 = clippointers[34];
		sPostPunchTrash3 = clippointers[35];
		sPostPunchTrash4 = clippointers[36];
		sNoddingOff = clippointers[37];
		sSleeping = clippointers[38];
		sVictory = clippointers[39];
		sDefeat = clippointers[40];
		sFalling = clippointers[41];
		sLeaving = clippointers[42];
	}

/****************************************************************************

*****	GetAndPlayInitSounds(String mediabase)

 ***************************************************************************/

//	URL audioURL; // This is actually declared above LoadSounds()

	public void GetAndPlayInitSounds(String mediabase)
	{

		try
		{
			audioURL = new URL(mediabase + "sInitingWords.au");
		}
		catch (MalformedURLException e) { cGameState = ERROR;
               	                                  cError = BADSOUNDURL;
						  cErrorString = cBADSOUNDURL; }

		if (audioURL != null)
		{
			sInitingWords = getAudioClip(audioURL);
		}

		try
		{
			audioURL = new URL(mediabase + "sInitingMusic.au");
		}
		catch (MalformedURLException e) { cGameState = ERROR;
               	                                  cError = BADSOUNDURL;
						  cErrorString = cBADSOUNDURL; }

		if (audioURL != null)
		{
			sInitingMusic = getAudioClip(audioURL);
		}

		sInitingWords.play();
		pause(sInitingWordsLength
+130);
// Above because of annoying netscape bug...

		sInitingMusic.loop();
	}

/****************************************************************************

*****	trashchance()

	Decide whether or not to trashtalk...

 ***************************************************************************/

	public boolean trashchance()
	{
		return( (Math.random()<cTrashChance)?true:false);
	}

/****************************************************************************

*****	pause( long length )

	Sleep this thread for length milliseconds.

 ***************************************************************************/

	public void pause(long length)
	{
		try { runner.sleep(length); }
		catch (InterruptedException e) { }
	}

/****************************************************************************

*****	PrepImages()

	Display all the images on some offscreen graphics so they are at the
	ready when it comes time to display them.	

 ***************************************************************************/

	public void PrepImages()
	{
		Image offscreenImage;
		Graphics offscreengraphics;

		offscreenImage = createImage(imagewidth, imageheight);
		offscreengraphics = offscreenImage.getGraphics();

		offscreengraphics.drawImage(iInputImage, 0, 0, this);
		offscreengraphics.drawImage(iIniting, 0, 0, this);
		offscreengraphics.drawImage(iSplash, 0, 0, this);
		offscreengraphics.drawImage(iWaiting, 0, 0, this);
		offscreengraphics.drawImage(iAroused, 0, 0, this);
		offscreengraphics.drawImage(iArousedTalking1, 0, 0, this);
		offscreengraphics.drawImage(iArousedTalking2, 0, 0, this);
		offscreengraphics.drawImage(iGettingReady, 0, 0, this);
		offscreengraphics.drawImage(iDanceLeft, 0, 0, this);
		offscreengraphics.drawImage(iDanceRight, 0, 0, this);
		offscreengraphics.drawImage(iPunchLeft, 0, 0, this);
		offscreengraphics.drawImage(iPunchRight, 0, 0, this);
		offscreengraphics.drawImage(iHitHi, 0, 0, this);
		offscreengraphics.drawImage(iHitLo, 0, 0, this);
		offscreengraphics.drawImage(iBlockHi, 0, 0, this);
		offscreengraphics.drawImage(iBlockLo, 0, 0, this);
		offscreengraphics.drawImage(iNoddingOff, 0, 0, this);
		offscreengraphics.drawImage(iSleeping, 0, 0, this);
		offscreengraphics.drawImage(iFalling, 0, 0, this);
		offscreengraphics.drawImage(iDefeat, 0, 0, this);
		offscreengraphics.drawImage(iPaused, 0, 0, this);
	}

/****************************************************************************

*****	PrepInitImage()

	Display the init image on some offscreen graphics so it is at the
	ready when it comes time to display it.

 ***************************************************************************/

	public void PrepInitImage()
	{
		Image offscreenImage;
		Graphics offscreengraphics;

		offscreenImage = createImage(imagewidth, imageheight);
		offscreengraphics = offscreenImage.getGraphics();

		offscreengraphics.drawImage(iInitImage, 0, 0, this);
	}

/****************************************************************************

*****	InitFightingVars()

	Get the fighting-related variables and the state stuff set up for
	fighting. Called (now) from PickingFight and keydown...

 ***************************************************************************/

	public void InitFightingVars()
	{
		cPunchResult = NOPUNCHES;
		cFocus = LOFOCUS;
		cCaseyHealth = 1.0;
		cEnemyHealth = 1.0;
		cGameState = FIGHTING;
		cCaseyState = GETTINGREADY;
	}

/****************************************************************************

*****	PauseGame()

	Pause the game. :-)

 ***************************************************************************/

	public void PauseGame()
	{
		g.drawImage(iPaused, 0, 0, this);
//		cGameState = PAUSED;
		if (cGameState != INITING)
			StopLoopingClips();
		else
			if (sInitingMusic != null)
				sInitingMusic.stop();
		runner.suspend();
	}

/****************************************************************************

*****	c( String s )

	Guess.

 ***************************************************************************/

	public void c(String s)
	{
		System.out.println(s);
	}

/****************************************************************************

*****	getAppletInfo()

	Standard stuff here.

 ***************************************************************************/

	public String getAppletInfo()
	{
		return("Box "+versionstring+" - Copyright "+copydatestring+" Casey Connor");
	}

} // End of Box.class
